/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.init.MysticItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class StrawberryBushBlock
extends BushBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private boolean hasPerfectBiomeConditions;

    public StrawberryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)MysticItems.STRAWBERRY.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 6;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int temperature = (int)((Biome)level.m_204166_(pos).m_203334_()).m_47554_();
        if ((Integer)state.m_61143_((Property)AGE) < 6) {
            int speed;
            this.hasPerfectBiomeConditions = false;
            if ((float)temperature >= 0.7f && level.m_45524_(pos.m_7494_(), 0) >= 7) {
                if ((float)temperature >= 0.95f) {
                    this.hasPerfectBiomeConditions = true;
                    speed = 128;
                } else {
                    speed = 384;
                }
            } else {
                speed = 896;
            }
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(speed) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if ((Integer)state.m_61143_((Property)AGE) == 6) {
            if (this.hasPerfectBiomeConditions && level.f_46441_.m_188503_(21) == 0) {
                StrawberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MysticItems.SWEET_STRAWBERRY.get(), 1));
            }
            StrawberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MysticItems.STRAWBERRY.get(), 2 + level.f_46441_.m_188503_(2)));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

